<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ForumReaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'reactable_id',
        'reactable_type',
        'type',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function reactable(): MorphTo
    {
        return $this->morphTo();
    }
    
    public static function getTypes(): array
    {
        return [
            'heart' => '❤️',
            'laugh' => '😂',
            'thumbs_up' => '👍',
            'thumbs_down' => '👎',
        ];
    }
}